<x-master-layout>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="d-flex align-items-center justify-content-between welcome-content">
                    <div class="navbar-breadcrumb">
                        <!-- <h4 class="mb-0 font-weight-700">Welcome To Dashboard</h4> -->
                    </div>
                    <div class="">
                        
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="row">
                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg fill="#4788ff" height="50px" width="52px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 60 60" xml:space="preserve" stroke="#4788ff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M52.29,44.29C52.109,44.479,52,44.74,52,45s0.1,0.52,0.29,0.71C52.479,45.89,52.74,46,53,46s0.52-0.11,0.71-0.29 C53.89,45.52,54,45.26,54,45s-0.11-0.521-0.29-0.71C53.34,43.93,52.67,43.92,52.29,44.29z"></path> <path d="M23.638,42.263L20,40.405v-0.387c1.628-0.889,2.773-2.354,3.412-4.365C24.381,35.14,25,34.14,25,33.018v-1 c0-0.927-0.431-1.786-1.151-2.35c-0.624-3.78-3.262-5.696-7.849-5.696c-0.217,0-0.429,0.009-0.636,0.025 c-0.865,0.067-2.129-0.003-3.224-0.741c-0.41-0.276-0.719-0.544-0.917-0.796c-0.336-0.428-0.901-0.577-1.401-0.369 c-0.501,0.206-0.796,0.708-0.733,1.248c0.042,0.372,0.105,0.808,0.2,1.285c0.193,0.975,0.193,0.975-0.078,1.558 c-0.102,0.221-0.228,0.49-0.376,0.853c-0.331,0.81-0.566,1.697-0.701,2.646C7.424,30.245,7,31.1,7,32.018v1 c0,1.122,0.619,2.122,1.588,2.636c0.639,2.012,1.784,3.477,3.412,4.365v0.376l-3.77,1.857C6.854,43.003,6,44.443,6,46.011v1.324 c0,0.803,0,2.683,10,2.683s10-1.88,10-2.683v-1.244C26,44.461,25.095,42.994,23.638,42.263z M24,47.109 c-0.623,0.379-3.161,0.908-8,0.908s-7.377-0.529-8-0.908v-1.099c0-0.835,0.456-1.603,1.151-1.983l3.858-1.9 C13.611,41.833,14,41.21,14,40.539v-1.804l-0.604-0.261c-1.517-0.652-2.503-1.899-3.015-3.814l-0.143-0.532l-0.526-0.164 C9.293,33.834,9,33.444,9,33.018v-1c0-0.363,0.207-0.699,0.541-0.877l0.469-0.25l0.055-0.528c0.099-0.939,0.308-1.804,0.622-2.57 c0.133-0.325,0.246-0.568,0.338-0.767c0.339-0.729,0.462-1.105,0.377-1.876c1.175,0.672,2.587,0.959,4.122,0.842 c0.155-0.013,0.314-0.02,0.477-0.02c3.744,0,5.572,1.356,5.929,4.399l0.062,0.523l0.466,0.245C22.792,31.316,23,31.652,23,32.018v1 c0,0.427-0.293,0.816-0.712,0.946l-0.526,0.164l-0.143,0.532c-0.512,1.915-1.498,3.162-3.015,3.814L18,38.735v1.812 c0,0.666,0.369,1.27,0.964,1.575l3.768,1.924l0.007,0.004C23.517,44.439,24,45.222,24,46.091V47.109z"></path> <path d="M31,29.018h10c0.553,0,1-0.447,1-1s-0.447-1-1-1H31c-0.553,0-1,0.447-1,1S30.447,29.018,31,29.018z"></path> <path d="M32,44.018h-1c-0.553,0-1,0.447-1,1s0.447,1,1,1h1c0.553,0,1-0.447,1-1S32.553,44.018,32,44.018z"></path> <path d="M38,44.018h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S38.553,44.018,38,44.018z"></path> <path d="M43,44.018h-1c-0.553,0-1,0.447-1,1s0.447,1,1,1h1c0.553,0,1-0.447,1-1S43.553,44.018,43,44.018z"></path> <path d="M49,44.018h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S49.553,44.018,49,44.018z"></path> <path d="M53,33.018H31c-0.553,0-1,0.447-1,1s0.447,1,1,1h22c0.553,0,1-0.447,1-1S53.553,33.018,53,33.018z"></path> <path d="M53,39.018H31c-0.553,0-1,0.447-1,1s0.447,1,1,1h22c0.553,0,1-0.447,1-1S53.553,39.018,53,39.018z"></path> <path d="M55.322,14H37V6.313C37,5.037,35.963,4,34.687,4h-9.375C24.037,4,23,5.037,23,6.313V14H4.678C2.099,14,0,16.099,0,18.678 v32.645C0,53.901,2.099,56,4.678,56h50.645C57.901,56,60,53.901,60,51.322V18.678C60,16.099,57.901,14,55.322,14z M25,6.313 C25,6.141,25.141,6,25.312,6h9.375C34.859,6,35,6.141,35,6.313V14v5.688C35,19.859,34.859,20,34.687,20h-9.375 C25.141,20,25,19.859,25,19.688V14V6.313z M58,51.322C58,52.799,56.799,54,55.322,54H4.678C3.201,54,2,52.799,2,51.322V18.678 C2,17.201,3.201,16,4.678,16H23v3.688C23,20.963,24.037,22,25.312,22h9.375C35.963,22,37,20.963,37,19.688V16h18.322 C56.799,16,58,17.201,58,18.678V51.322z"></path> <path d="M30,15c2.206,0,4-1.794,4-4s-1.794-4-4-4s-4,1.794-4,4S27.794,15,30,15z M30,9c1.103,0,2,0.897,2,2s-0.897,2-2,2 s-2-0.897-2-2S28.897,9,30,9z"></path> </g> </g></svg>
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ $data['dashboard']['total_driver'] }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.total_driver') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg width="52" height="45" viewBox="0 0 800 800" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <ellipse cx="339.825" cy="194.5" rx="137" ry="150.5" stroke="#4788ff" stroke-width="52"/>
                                            <ellipse cx="541.825" cy="572.5" rx="184" ry="184.5" stroke="#4788ff" stroke-width="52"/>
                                            <path d="M539.825 480V561.5L604.5 637.5" stroke="#4788ff" stroke-width="52" stroke-linecap="round"/>
                                            <path d="M298.325 508C276.992 507 227.625 498.6 200.825 473C167.325 441 116.325 463 107.325 485.5C97.6585 494.5 77.7252 522.3 75.3252 561.5V656.5C78.4919 672.5 96.4253 703.5 142.825 699.5H327.825" stroke="#4788ff" stroke-width="52"/>
                                        </svg>                                        
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ $data['dashboard']['pending_driver'] }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.pending_driver') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg fill="#4788ff" height="50px" width="52px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 294.841 294.841" xml:space="preserve" stroke="#4788ff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M64.78,72.898c13.162,0,23.831-10.662,23.831-23.831c0-13.161-10.669-23.823-23.831-23.823 c-13.165,0-23.832,10.662-23.832,23.823C40.948,62.236,51.615,72.898,64.78,72.898z"></path> <path d="M93.667,98h63.99c5.629,0,10.191-4.563,10.191-10.191s-4.563-10.191-10.191-10.191 c-54.999-0.031-111.486-0.041-112.848,0.027c-4.092,0.205-8.1,1.982-9.903,5.932L0.923,158.024 c-2.337,5.121-0.081,11.166,5.039,13.504c5.128,2.34,11.169,0.075,13.504-5.039l16.424-35.979c0,40.338-0.03,126.857-0.03,126.857 c0,6.755,5.476,12.23,12.231,12.23s12.23-5.476,12.23-12.23v-72.879h8.917v72.879c0,6.755,5.476,12.23,12.23,12.23 c6.755,0,12.23-5.476,12.23-12.23C93.698,111.141,93.667,194.591,93.667,98z"></path> <path d="M290.206,154.464h-15.892l-11.085-27.976c-2.397-6.05-8.246-10.023-14.754-10.023h-85.578 c-6.604,0-12.517,4.089-14.848,10.267l-10.466,27.733h-15.608c-2.56,0-4.635,2.075-4.635,4.635v8.73 c0,2.559,2.075,4.635,4.635,4.635h10.781v35.966c0,5.817,4.716,10.534,10.534,10.534h4.8v3c0,8.284,6.716,15,15,15s15-6.716,15-15 v-3h56v3c0,8.284,6.716,15,15,15c8.284,0,15-6.716,15-15v-3h4.799c5.818,0,10.534-4.717,10.534-10.534v-35.966h10.782 c2.56,0,4.635-2.075,4.635-4.635v-8.73C294.841,156.539,292.765,154.464,290.206,154.464z M180.249,194.412 c0,2.609-2.162,4.636-4.635,4.636h-25.047c-2.475,0-4.635-2.027-4.635-4.636v-8.729c0-2.609,2.162-4.636,4.635-4.636h25.047 c2.475,0,4.635,2.027,4.635,4.636V194.412z M266.249,194.412c0,2.609-2.162,4.636-4.635,4.636h-25.047 c-2.475,0-4.635-2.027-4.635-4.636v-8.729c0-2.609,2.162-4.636,4.635-4.636h25.047c2.475,0,4.635,2.027,4.635,4.636V194.412z"></path> <path d="M191.341,108.464h29.5c4.143,0,7.5-3.357,7.5-7.5c0-4.143-3.357-7.5-7.5-7.5h-29.5c-4.143,0-7.5,3.357-7.5,7.5 C183.841,105.107,187.198,108.464,191.341,108.464z"></path> </g> </g></svg>
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ $data['dashboard']['total_rider'] }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.total_rider') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="52px" height="50px" viewBox="0 0 512 512" xml:space="preserve" fill="#4788ff" stroke="#4788ff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <style type="text/css">  .st0{fill:#4788ff;}  </style> <g> <path class="st0" d="M34.313,250.891c2.297-5.016,6.688-13.281,14.438-27.813c3.531-6.672,7.5-14.047,11.563-21.625H24.719 C11.063,201.453,0,212.516,0,226.188c0,13.641,11.063,24.703,24.719,24.703H34.313z"></path> <path class="st0" d="M487.281,201.453h-35.594c4.078,7.578,8.031,14.953,11.563,21.625c7.75,14.531,12.125,22.797,14.438,27.813 h9.594c13.656,0,24.719-11.063,24.719-24.703C512,212.516,500.938,201.453,487.281,201.453z"></path> <path class="st0" d="M39.391,465.188c0,18.406,14.938,33.328,33.328,33.328c18.406,0,33.313-14.922,33.313-33.328v-31.516H39.391 V465.188z"></path> <path class="st0" d="M405.938,465.188c0,18.406,14.938,33.328,33.344,33.328s33.328-14.922,33.328-33.328v-31.516h-66.672V465.188z "></path> <path class="st0" d="M467.875,257.109c1.688,0.484-61.688-115.828-64.719-122.109c-8-16.672-27.781-26.703-47.063-26.703 c-22.281,0-84.344,0-84.344,0s-93.563,0-115.859,0c-19.297,0-39.031,10.031-47.047,26.703 c-3.031,6.281-66.391,122.594-64.719,122.109c0,0-20.5,20.438-22.063,22.063c-8.625,9.281-8,17.297-8,25.313c0,0,0,75.297,0,92.563 c0,17.281,3.063,26.734,23.438,26.734h437c20.375,0,23.469-9.453,23.469-26.734c0-17.266,0-92.563,0-92.563 c0-8.016,0.594-16.031-8.063-25.313C488.406,277.547,467.875,257.109,467.875,257.109z M96.563,221.422 c0,0,40.703-73.313,43.094-78.109c4.125-8.203,15.844-14.141,27.828-14.141h177.031c12,0,23.703,5.938,27.828,14.141 c2.406,4.797,43.109,78.109,43.109,78.109c3.75,6.75,0.438,19.313-10.672,19.313H107.219 C96.109,240.734,92.813,228.172,96.563,221.422z M91.125,384.469c-20.656,0-37.406-16.734-37.406-37.391 c0-20.672,16.75-37.406,37.406-37.406s37.391,16.734,37.391,37.406C128.516,367.734,111.781,384.469,91.125,384.469z M312.781,394.578c0,2.734-2.219,4.953-4.938,4.953H204.172c-2.734,0-4.953-2.219-4.953-4.953v-45.672 c0-2.703,2.219-4.906,4.953-4.906h103.672c2.719,0,4.938,2.203,4.938,4.906V394.578z M420.875,384.469 c-20.656,0-37.422-16.734-37.422-37.391c0-20.672,16.766-37.406,37.422-37.406s37.406,16.75,37.406,37.406 S441.531,384.469,420.875,384.469z"></path> <path class="st0" d="M152.906,49.25c0.016-10.047,8.172-18.203,18.219-18.219h169.75c10.031,0.016,18.188,8.172,18.203,18.219 v49.172h17.547V49.25c0-19.75-16-35.75-35.75-35.766h-169.75c-19.75,0.016-35.75,16.016-35.766,35.766v49.172h17.547V49.25z"></path> <path class="st0" d="M195.141,92.938h8.891c0.438,0,0.719-0.266,0.719-0.672V56.328c0-0.281,0.156-0.422,0.406-0.422h12.063 c0.406,0,0.719-0.266,0.719-0.672v-7.469c0-0.406-0.313-0.688-0.719-0.688h-35.25c-0.438,0-0.719,0.281-0.719,0.688v7.469 c0,0.406,0.281,0.672,0.719,0.672h12.047c0.281,0,0.422,0.141,0.422,0.422v35.938C194.438,92.672,194.719,92.938,195.141,92.938z"></path> <path class="st0" d="M237.438,47.078c-0.5,0-0.781,0.281-0.922,0.688l-16.391,44.5c-0.156,0.406,0,0.672,0.469,0.672h9.203 c0.484,0,0.766-0.203,0.906-0.672l2.672-8.031h16.688l2.719,8.031c0.156,0.469,0.438,0.672,0.938,0.672h9.094 c0.5,0,0.625-0.266,0.5-0.672l-16.125-44.5c-0.156-0.406-0.406-0.688-0.922-0.688H237.438z M247.25,75.813h-11l5.406-16.047h0.203 L247.25,75.813z"></path> <path class="st0" d="M269.844,92.938h9.688c0.625,0,0.906-0.203,1.188-0.672l8.531-13.969h0.219l8.5,13.969 c0.281,0.469,0.531,0.672,1.188,0.672h9.734c0.516,0,0.641-0.406,0.453-0.813l-14.313-22.859l13.297-21.375 c0.234-0.406,0.078-0.813-0.406-0.813h-9.734c-0.563,0-0.844,0.203-1.141,0.688l-7.578,12.391h-0.219l-7.563-12.391 c-0.266-0.484-0.547-0.688-1.125-0.688h-9.75c-0.469,0-0.625,0.406-0.406,0.813l13.266,21.375l-14.234,22.859 C269.156,92.531,269.359,92.938,269.844,92.938z"></path> <path class="st0" d="M320.422,47.766v44.5c0,0.406,0.281,0.672,0.688,0.672h8.922c0.406,0,0.688-0.266,0.688-0.672v-44.5 c0-0.406-0.281-0.688-0.688-0.688h-8.922C320.703,47.078,320.422,47.359,320.422,47.766z"></path> </g> </g></svg>
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ $data['dashboard']['total_ride'] }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.total_ride') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg fill="#4788ff" height="50px" width="52px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 490.766 490.766" xml:space="preserve" stroke="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M472.554,319.199c-9.4-0.7-28.8,9.8-34.1,12.5c-18.9,9.5-45.2,24.4-62.5,36.3c-1.2,0.8-2.8,1.9-4,2.7 c-7.8,5-16,8.3-25.1,10.3c-50.2,10.7-123.3,11.8-123.3,11.8l-4.3,0.2c-3.2,0.2-6.1-2.1-6.5-5.2c-0.5-3.4,2-6.6,5.6-6.9l108.7-10.3 c12-1.3,21.5-12.5,20.2-25.1s-12.9-21.8-24.9-20.5l-96.7-1.2c-6.6-0.1-17.1-1.7-23.4-3.6c-62.3-18.2-97.5-1.2-116.2,6.8 c-4.2-6.9-12.1-11.4-20.9-10.8l-41.7,2.8c-13.9,0.9-24.3,12.5-23.4,25.9l6.7,92.6c1,13.4,13,23.5,26.9,22.5l41.7-2.8 c8.8-0.6,16-6,19.1-13.4l183.2,7.9c20.4,2.2,39.5-0.3,57.5-9.7l5.2-2.7l138.5-81c6.8-4,11.6-10.9,11.9-18.5 C491.054,330.499,485.754,320.199,472.554,319.199z M48.954,438.099c-7.8,0-14.2-6.1-14.2-13.7s6.4-13.7,14.2-13.7 s14.2,6.1,14.2,13.7S56.754,438.099,48.954,438.099z M367.654,333.399c14.6-8,43.2-21.8,58.8-27.9c7.8-3.1,15.5-2.9,22.6,1.9 c-5.6,2-10.8,4.5-15.7,6.9c-16.4,8.2-45.3,23.9-59.4,33.8c-1.4,1-2.9,2-4.3,3c0.2-2.5,0.2-5.1-0.1-7.7c-0.3-3.3-1.1-6.4-2.1-9.4 C367.454,333.799,367.554,333.599,367.654,333.399z M411.354,296.199c-11.3,5-33,12.6-43.3,18.3l-7,3.8c-0.7,0.4-1.3,0.8-1.9,1.3 c-3.1-3.7-6.8-6.8-10.9-9.3c9.6-5.1,31-12,40.7-15.8C396.754,291.399,404.254,291.599,411.354,296.199z M114.954,232.999 c0-5.8,4.7-10.5,10.5-10.5h261.7c5.8,0,10.5,4.7,10.5,10.5s-4.7,10.5-10.5,10.5h-261.8 C119.654,243.499,114.954,238.799,114.954,232.999z M114.954,270.999c0-5.8,4.7-10.5,10.5-10.5h261.7c5.8,0,10.5,4.7,10.5,10.5 s-4.7,10.5-10.5,10.5h-261.8C119.654,281.499,114.954,276.799,114.954,270.999z M319.554,118.299c0-8.2,6.7-14.9,14.9-14.9 c8.2,0,14.9,6.7,14.9,14.9s-6.7,14.9-14.9,14.9C326.154,133.199,319.554,126.499,319.554,118.299z M163.254,118.299 c0-8.2,6.7-14.9,14.9-14.9s14.9,6.7,14.9,14.9s-6.7,14.9-14.9,14.9C169.854,133.199,163.254,126.499,163.254,118.299z M139.254,205.899h234c13.5,0,24.5-11,24.5-24.5v-126.2c0-13.5-11-24.5-24.5-24.5h-234c-13.5,0-24.5,11-24.5,24.5v126.2 C114.754,194.899,125.754,205.899,139.254,205.899z M135.654,80.599c1.4,0.3,2.9,0.4,4.4,0.4c13.7,0,24.8-11.1,24.8-24.8 c0-1.6-0.1-3.1-0.4-4.6h182.2c-0.5,1.9-0.8,4-0.8,6.1c0,13.7,11.1,24.8,24.8,24.8c2.1,0,4.2-0.3,6.1-0.8v76.1c-2-0.5-4-0.8-6.1-0.8 c-13.7,0-24.8,11.1-24.8,24.8c0,1,0.1,2.1,0.2,3.1h-181.6c0.3-1.5,0.4-3,0.4-4.6c0-13.7-11.1-24.8-24.8-24.8 c-1.5,0-2.9,0.1-4.4,0.4V80.599z M234.954,118.299c0-11.8,9.6-21.5,21.5-21.5c11.8,0,21.5,9.6,21.5,21.5c0,11.8-9.6,21.5-21.5,21.5 S234.954,130.199,234.954,118.299z M256.454,171.899c29.6,0,53.5-24,53.5-53.5s-24-53.5-53.5-53.5c-29.6,0-53.5,24-53.5,53.5 S226.854,171.899,256.454,171.899z M256.454,82.399c19.8,0,35.9,16.1,35.9,35.9s-16.1,35.9-35.9,35.9s-35.9-16.1-35.9-35.9 S236.654,82.399,256.454,82.399z"></path> </g> </g></svg>
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ getPriceFormat($data['dashboard']['today_earning']) }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.today_earning') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg width="52px" height="50px" viewBox="-2.4 -2.4 28.80 28.80" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="#000000000" stroke-width="0.00024000000000000003" transform="matrix(1, 0, 0, 1, 0, 0)rotate(0)"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round" stroke="#4788ff" stroke-width="0.048"></g><g id="SVGRepo_iconCarrier"> <path d="M20 15C20.5523 15 21 14.5523 21 14C21 13.4477 20.5523 13 20 13C19.4477 13 19 13.4477 19 14C19 14.5523 19.4477 15 20 15Z" fill="#4788ff"></path> <path fill-rule="evenodd" clip-rule="evenodd" d="M16.775 0.985398C18.4919 0.460783 20.2821 1.55148 20.6033 3.3178L20.9362 5.14896C22.1346 5.54225 23 6.67006 23 8V10.7639C23.6137 11.3132 24 12.1115 24 13V15C24 15.8885 23.6137 16.6868 23 17.2361V20C23 21.6569 21.6569 23 20 23H4C2.34315 23 1 21.6569 1 20V8C1 6.51309 2.08174 5.27884 3.50118 5.04128L16.775 0.985398ZM21 16C21.5523 16 22 15.5523 22 15V13C22 12.4477 21.5523 12 21 12H18C17.4477 12 17 12.4477 17 13V15C17 15.5523 17.4477 16 18 16H21ZM21 18V20C21 20.5523 20.5523 21 20 21H4C3.44772 21 3 20.5523 3 20V8C3 7.44772 3.44772 7 4 7H20C20.55 7 20.9962 7.44396 21 7.99303L21 10H18C16.3431 10 15 11.3431 15 13V15C15 16.6569 16.3431 18 18 18H21ZM18.6954 3.60705L18.9412 5H10L17.4232 2.82301C17.9965 2.65104 18.5914 3.01769 18.6954 3.60705Z" fill="#4788ff"></path> </g></svg>
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ getPriceFormat($data['dashboard']['monthly_earning']) }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.monthly_earning') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg fill="#4788ff" height="64px" width="64px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 491.4 491.4" xml:space="preserve" stroke="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round" stroke="#CCCCCC" stroke-width="0.9827999999999999"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M89.6,224.6c11.6,0,21,9.4,21,21c0,11.6-9.4,21-21,21c-11.6,0-21-9.4-21-21C68.5,234,77.9,224.6,89.6,224.6z M34.7,369.4 H282c-0.8-2.6-1.2-5.3-1.2-8.1v-21.5H70.3c0.4-2.1,0.6-4.2,0.6-6.5c0-19.4-15.7-35.1-35.1-35.1c-2.1,0-4.2,0.2-6.2,0.6V192.4 c2,0.4,4.1,0.6,6.2,0.6c19.4,0,35.1-15.7,35.1-35.1c0-2.2-0.2-4.4-0.6-6.5h257.4c-0.7,2.7-1.1,5.6-1.1,8.6 c0,15.3,9.9,28.3,23.6,33.1c1.7-14.2,13.8-25.3,28.4-25.3H400v-11.3c0-19.1-15.5-34.6-34.7-34.6H34.7C15.6,121.9,0,137.4,0,156.5 v178.3C0,353.8,15.6,369.4,34.7,369.4z M309.5,246.5c-4.5,0-8.1,3.6-8.1,8.1v106.7c0,4.5,3.6,8.1,8.1,8.1h35.7 c4.5,0,8.1-3.6,8.1-8.1V254.6c0-4.5-3.6-8.1-8.1-8.1H309.5z M414.2,188.3h-35.7c-4.5,0-8.1,3.6-8.1,8.1v164.9 c0,4.5,3.6,8.1,8.1,8.1h35.7c4.5,0,8.1-3.6,8.1-8.1V196.4C422.3,192,418.7,188.3,414.2,188.3z M483.3,283.7h-35.7 c-4.5,0-8.1,3.6-8.1,8.1v69.6c0,4.5,3.6,8.1,8.1,8.1h35.7c4.5,0,8.1-3.6,8.1-8.1v-69.6C491.4,287.3,487.7,283.7,483.3,283.7z M200,169.7c41.8,0,75.9,34,75.9,75.9c0,41.8-34,75.9-75.9,75.9c-41.8,0-75.9-34-75.9-75.9C124.1,203.8,158.1,169.7,200,169.7z M224.1,214l-33.9,33.7L176,233.4l-14.8,14.7l14.2,14.3l14.7,14.8l14.8-14.7l33.9-33.7L224.1,214z"></path> </g> </g></svg>
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ getPriceFormat($data['dashboard']['total_earning']) }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.total_earning') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="card card-block card-stretch card-height border-radius-20">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="mm-cart-image text-light">
                                        <svg fill="#4788ff" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="52px" height="50px" viewBox="0 0 236 256" enable-background="new 0 0 236 256" xml:space="preserve" stroke="#4788ff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M117.5,2c-12.47,0-22.63,10.16-22.63,22.63c0,12.46,10.06,22.62,22.63,22.62c12.37,0,22.62-10.16,22.62-22.62 C140.12,12.16,129.97,2,117.5,2z M146,52H89c-15.59,0-28,13.41-28,29v32h20V86c0-1.71,1.29-3,3-3s3,1.29,3,3v27h61V86 c0-1.71,1.29-3,3-3s3,1.29,3,3v27h20V81C174,65.51,161.49,52,146,52z M2,118v27h23v109h185V145h24v-27H2z M88.23,146.33 c1.17-1.17,3.06-1.19,4.25-0.01c0.01,0.01,15.38,15.36,15.38,15.36v0.02c1.13,1.13,1.25,3.03,0.01,4.27v0.01 c0,0.01-5.42,5.41-5.42,5.41l-19.64-19.63L88.23,146.33z M99.3,201.73c-27.19-27.88-20.85-44.9-17.99-48.47l19.65,19.62 c-2.8,2.8-0.09,6.78,2.98,10.58c4.37,5.41,9.4,10.22,13.78,13.78c6.62,5.4,10.07,7.77,12.74,5.1l19.16,19.16 C146.44,224.81,127.95,231.09,99.3,201.73z M156.55,214.64l-0.01,0.01c0,0.01-5.42,5.42-5.42,5.42l-19.21-19.21l5.43-5.43 c1.16-1.16,3.06-1.19,4.24-0.01c0.01,0.01,14.95,14.94,14.95,14.94v0.01C157.66,211.5,157.78,213.4,156.55,214.64z"></path> </g></svg>
                                    </div>
                                    <div class="mm-cart-text">
                                        <h5 class="float-right font-weight-700">{{ $data['dashboard']['complaint'] }}</h5><br>
                                        <p class="mb-0 float-right">{{ __('message.complaint') }}</p>
                                    </div>                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card card-block card-stretch card-height border-radius-20 ">
                    <div class="card-header d-flex justify-content-between border-radius-20">
                        <div class="header-title">
                            <h4 class="card-title">{{ __('message.recent_request') }}</h4>
                        </div>
                        <div class="card-header-toolbar d-flex align-items-center">
                        </div>
                    </div>
                    <div class="card-body align-items-center">
                        <div class="table-responsive">
                            <table class="table mb-1 table-striped text-center">
                                <thead>
                                    <tr>
                                        <th scope='col'>#</th>
                                        <th scope='col'>{{ __('message.rider') }}</th>
                                        <th scope='col'>{{ __('message.requested_date') }}</th>
                                        <th scope='col'>{{ __('message.driver') }}</th>
                                        <th scope='col'>{{ __('message.status') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if( count($recent_riderequest) > 0 )
                                        @foreach ($recent_riderequest as $riderequest)
                                            @php
                                                $status = 'primary';
                                                $ride_status = $riderequest->status;
                                                switch ($ride_status) {
                                                    case 'pending':
                                                        $status = 'warning';
                                                        break;
                                                    case 'canceled':
                                                        $status = 'danger';
                                                        break;
                                                    case 'completed':
                                                        $status = 'success';
                                                        break;
                                                    default:
                                                        // $ride_status = '-';
                                                        break;
                                                }
                                                @endphp
                                            <tr>
                                                <td>{{ $riderequest->id }}</td>
                                                <td>{{ optional($riderequest->rider)->display_name ?? '-' }}</td>
                                                <td>{{ dateAgoFormate($riderequest->datetime, true) }}</td>
                                                <td>{{ optional($riderequest->driver)->display_name ?? '-' }}</td>
                                                <td><span class="badge badge-light-{{$status}} text-{{$status}}">{{ __('message.'.$riderequest->status) }}</span></td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="5">{{ __('message.no_record_found') }}</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card card-block card-stretch card-height border-radius-20 ">
                    <div class="card-header d-flex justify-content-between border-radius-20">
                        <div class="header-title">
                            <h4 class="card-title">{{ __('message.income') }}</h4>
                        </div>
                        <div class="card-header-toolbar d-flex align-items-center">
                        </div>
                    </div>
                    <div class="card-body align-items-center">
                        <div id="dash-income-chart"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page end  -->
    </div>
    @section('bottom_script')
    <script>
        
        var options = {
            series: [{
                name: "{{ __('message.cash') }}",
                data: [ <?= implode ( ',' , $data['cash_yearly'] ) ?> ]
            }, {
                name: "{{ __('message.wallet') }}",
                data:[ <?= implode ( ',' , $data['wallet_yearly'] ) ?> ]
            }],
            chart: {
                type: 'bar',
                height: 350
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '55%',
                    endingShape: 'rounded'
                },
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                show: true,
                width: 2,
                colors: ['transparent']
            },
            xaxis: {
                categories: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
            },
            yaxis: {
                title: {
                    text: ''
                }
            },
            fill: {
                opacity: 1
            },
            tooltip: {
                y: {
                    formatter: function (val) {
                        return val
                    }
                }
            }
        };

        var chart = new ApexCharts(document.querySelector("#dash-income-chart"), options);
        chart.render();
    </script>
    @endsection
</x-master-layout>
